/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.steam;

import com.codedisaster.steamworks.SteamAPI;
import com.codedisaster.steamworks.SteamApps;
import com.codedisaster.steamworks.SteamException;
import com.codedisaster.steamworks.SteamFriends;
import com.codedisaster.steamworks.SteamID;
import com.codedisaster.steamworks.SteamLeaderboardHandle;
import com.codedisaster.steamworks.SteamRemoteStorage;
import com.codedisaster.steamworks.SteamUGCFileWriteStreamHandle;
import com.codedisaster.steamworks.SteamUser;
import com.codedisaster.steamworks.SteamUserStats;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.screens.leaderboards.FilterButton;
import com.megacrit.cardcrawl.steam.CloudFileManifest;
import com.megacrit.cardcrawl.steam.SFCallback;
import com.megacrit.cardcrawl.steam.SRCallback;
import com.megacrit.cardcrawl.steam.SSCallback;
import com.megacrit.cardcrawl.steam.SUCallback;
import com.megacrit.cardcrawl.steam.SteamTicker;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SteamSaveSync {
    private static final Logger logger = LogManager.getLogger(SteamSaveSync.class.getName());
    private static final Logger LOGGER = LogManager.getLogger(SteamSaveSync.class.getName());
    public static SteamUserStats steamStats;
    public static SteamUser steamUser;
    private static SteamApps steamApps;
    public static SteamFriends steamFriends;
    private static Thread thread;
    public static int accountId;
    public static SteamLeaderboardHandle lbHandle;
    public static LeaderboardTask task;
    public static boolean retrieveGlobal;
    public static boolean gettingTime;
    public static int lbScore;
    public static int startIndex;
    public static int endIndex;
    public static boolean isUploadingScore;
    public static Queue<StatTuple> statsToUpload;

    public static void initializeSteamApi() {
        if (!Settings.isDemo) {
            try {
                if (SteamAPI.init()) {
                    LOGGER.info("[SUCCESS] Steam API initialized successfully.");
                    steamStats = new SteamUserStats(new SSCallback());
                    steamUser = new SteamUser(new SUCallback());
                    steamApps = new SteamApps();
                    steamFriends = new SteamFriends(new SFCallback());
                    LOGGER.info("BUILD ID: " + steamApps.getAppBuildId());
                    LOGGER.info("CURRENT LANG: " + steamApps.getCurrentGameLanguage());
                    SteamID id = steamApps.getAppOwner();
                    accountId = id.getAccountID();
                    LOGGER.info("ACCOUNT ID: " + accountId);
                    thread = new Thread(new SteamTicker());
                    thread.start();
                } else {
                    LOGGER.info("[FAILURE] Steam API failed to initialize correctly.");
                }
            }
            catch (SteamException e) {
                e.printStackTrace();
            }
        }
    }

    public static ArrayList<String> getAllCloudFiles() {
        SteamRemoteStorage remoteStorage = new SteamRemoteStorage(new SRCallback());
        int numFiles = remoteStorage.getFileCount();
        LOGGER.info("Num of files: " + numFiles);
        ArrayList<String> files = new ArrayList<String>();
        for (int i = 0; i < numFiles; ++i) {
            int[] sizes = new int[1];
            String file = remoteStorage.getFileNameAndSize(i, sizes);
            boolean exists = remoteStorage.fileExists(file);
            if (exists) {
                files.add(file);
            }
            LOGGER.info("# " + i + " : name=" + file + ", size=" + sizes[0] + ", exists=" + (exists ? "yes" : "no"));
        }
        remoteStorage.dispose();
        return files;
    }

    public static void syncAllFiles(String preferenceDir) {
        LOGGER.info("Syncing all files");
        CloudFileManifest filenames = new CloudFileManifest();
        for (String file : filenames.getFileNames(preferenceDir)) {
            try {
                LOGGER.info("Syncing: " + file);
                SteamSaveSync.syncFileToCloud(file, SteamSaveSync.basename(file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SteamException e) {
                e.printStackTrace();
            }
        }
    }

    public static void deleteAllCloudFiles(ArrayList<String> files) {
        SteamRemoteStorage remoteStorage = new SteamRemoteStorage(new SRCallback());
        for (String file : files) {
            LOGGER.info("Deleting file: " + file);
            remoteStorage.fileDelete(file);
        }
        remoteStorage.dispose();
    }

    public static void deleteRemoteFile(String remoteFilename) {
        SteamRemoteStorage remoteStorage = new SteamRemoteStorage(new SRCallback());
        LOGGER.info("Deleting file: " + remoteFilename);
        remoteStorage.fileDelete(remoteFilename);
        remoteStorage.dispose();
    }

    public static String readRemoteFile(String remoteFilename) throws SteamException, FileNotFoundException {
        SteamRemoteStorage remoteStorage = new SteamRemoteStorage(new SRCallback());
        Boolean remoteFileExists = remoteStorage.fileExists(remoteFilename);
        if (remoteFileExists.booleanValue()) {
            int fileSize = remoteStorage.getFileSize(remoteFilename);
            ByteBuffer readBuffer = ByteBuffer.allocateDirect(fileSize);
            if (!remoteStorage.fileRead(remoteFilename, readBuffer, fileSize)) {
                LOGGER.warn("Read of remotefile '" + remoteFilename + "' failed. ");
            }
            readBuffer.rewind();
            byte[] dst = new byte[fileSize];
            for (int i = 0; i < fileSize; ++i) {
                dst[i] = readBuffer.get();
            }
            String output = new String(dst);
            LOGGER.info("The remote file contents: '" + output + "' were read.");
            remoteStorage.dispose();
            return output;
        }
        throw new FileNotFoundException("The remoteFile '" + remoteFilename + "' does not exist.");
    }

    public static void writeRemoteFile(String remoteFilename, String contents) {
        SteamRemoteStorage remoteStorage = new SteamRemoteStorage(new SRCallback());
        ByteBuffer writeBuffer = ByteBuffer.allocateDirect(contents.getBytes().length);
        writeBuffer.put(contents.getBytes());
        writeBuffer.flip();
        LOGGER.info("Finished with writing to buffer. Buffer: " + writeBuffer.toString());
        SteamUGCFileWriteStreamHandle filestream = remoteStorage.fileWriteStreamOpen(remoteFilename);
        if (filestream == null) {
            LOGGER.warn("The filestream is null!!!");
        }
        remoteStorage.fileWriteStreamWriteChunk(filestream, writeBuffer, writeBuffer.remaining());
        remoteStorage.fileWriteStreamClose(filestream);
        LOGGER.info("Verifying that file '" + remoteFilename + "' was written: " + remoteStorage.fileExists(remoteFilename));
        remoteStorage.dispose();
    }

    public static void writeLocalFile(String localFilename, String contents) throws IOException {
        BufferedWriter localFileWriter = new BufferedWriter(new FileWriter(localFilename));
        localFileWriter.write(contents);
        ((Writer)localFileWriter).close();
        LOGGER.info("The local file '" + localFilename + "'has been written.");
    }

    public static String readLocalFile(String localFilename) throws IOException {
        Boolean localFileExists = new File(localFilename).isFile();
        if (localFileExists.booleanValue()) {
            return new String(Files.readAllBytes(Paths.get(localFilename, new String[0])));
        }
        throw new FileNotFoundException("The file '" + localFilename + "' does not exist.");
    }

    public static String basename(String path) {
        Path p = Paths.get(path, new String[0]);
        return p.getFileName().toString();
    }

    public static void syncFileToCloud(String localFilePath, String remoteFilename) throws IOException, SteamException {
        if (SteamAPI.isSteamRunning()) {
            SteamRemoteStorage remoteStorage = new SteamRemoteStorage(new SRCallback());
            Boolean localFileExists = new File(localFilePath).isFile();
            Boolean remoteFileExists = remoteStorage.fileExists(remoteFilename);
            if (localFileExists.booleanValue()) {
                String localFileContents = SteamSaveSync.readLocalFile(localFilePath);
                SteamSaveSync.writeRemoteFile(remoteFilename, localFileContents);
            } else if (remoteFileExists.booleanValue()) {
                String remoteFileContents = SteamSaveSync.readRemoteFile(remoteFilename);
                SteamSaveSync.writeLocalFile(localFilePath, remoteFileContents);
            }
            remoteStorage.dispose();
        } else {
            LOGGER.info("Steam is not running. Cannot synchronize cloud saves.");
        }
    }

    public static void unlockAchievement(String id) {
        if (steamStats != null) {
            if (steamStats.setAchievement(id)) {
                steamStats.storeStats();
            } else {
                logger.info("[ERROR] Could not find achievement " + id);
            }
        }
    }

    public static void removeAllAchievementsBeCarefulNotToPush() {
        if (Settings.isDev && Settings.isBeta && steamStats != null && steamStats.resetAllStats(true)) {
            steamStats.storeStats();
        }
    }

    public static boolean incrementStat(String id, int incrementAmt) {
        if (steamStats != null) {
            if (steamStats.setStatI(id, SteamSaveSync.getStat(id) + incrementAmt)) {
                return true;
            }
            logger.info("Stat: " + id + " not found.");
            return false;
        }
        logger.info("[ERROR] Could not find stat " + id);
        return false;
    }

    public static int getStat(String id) {
        if (steamStats != null) {
            return steamStats.getStatI(id, 0);
        }
        return -1;
    }

    public static boolean resetStat(String id) {
        if (steamStats != null) {
            if (steamStats.resetAllStats(false)) {
                logger.info("Reset all stats");
                return true;
            }
            if (steamStats.setStatI(id, 0)) {
                return true;
            }
            logger.info("Stat: " + id + " not found.");
            return false;
        }
        logger.info("Steam API not initialized.");
        return false;
    }

    public static long getGlobalStat(String id) {
        if (steamStats != null) {
            return steamStats.getGlobalStat(id, 0L);
        }
        return -1L;
    }

    public static void requestGlobalStats(int i) {
        if (steamStats != null) {
            steamStats.requestGlobalStats(i);
        }
    }

    public static void getLeaderboardEntries(AbstractPlayer.PlayerClass pClass, FilterButton.RegionSetting rSetting, FilterButton.LeaderboardType lType, int start, int end) {
        task = LeaderboardTask.RETRIEVE;
        startIndex = start;
        endIndex = end;
        gettingTime = lType == FilterButton.LeaderboardType.FASTEST_WIN;
        retrieveGlobal = rSetting == FilterButton.RegionSetting.GLOBAL;
        if (steamStats != null) {
            steamStats.findLeaderboard(SteamSaveSync.createGetLeaderboardString(pClass, lType));
        }
    }

    private static String createGetLeaderboardString(AbstractPlayer.PlayerClass pClass, FilterButton.LeaderboardType lType) {
        String retVal = "";
        switch (pClass) {
            case IRONCLAD: {
                retVal = retVal + "IRONCLAD";
                break;
            }
            case THE_SILENT: {
                retVal = retVal + "SILENT";
                break;
            }
            case CROWBOT: {
                retVal = retVal + "CROWBOT";
                break;
            }
        }
        switch (lType) {
            case AVG_FLOOR: {
                retVal = retVal + "_AVG_FLOOR";
                break;
            }
            case AVG_SCORE: {
                retVal = retVal + "_AVG_SCORE";
                break;
            }
            case CONSECUTIVE_WINS: {
                retVal = retVal + "_CONSECUTIVE_WINS";
                break;
            }
            case FASTEST_WIN: {
                retVal = retVal + "_FASTEST_WIN";
                break;
            }
            case HIGH_SCORE: {
                retVal = retVal + "_HIGH_SCORE";
                break;
            }
            case SPIRE_LEVEL: {
                retVal = retVal + "_SPIRE_LEVEL";
                break;
            }
        }
        if (Settings.isBeta) {
            retVal = retVal + "_BETA";
        }
        return retVal;
    }

    public static void uploadLeaderboardScore(String name, int score) {
        if (steamUser == null || steamStats == null) {
            return;
        }
        if (isUploadingScore) {
            statsToUpload.add(new StatTuple(name, score));
        } else {
            logger.info(String.format("Uploading Steam Leaderboard score (%s: %d)", name, score));
            isUploadingScore = true;
            task = LeaderboardTask.UPLOAD;
            lbScore = score;
            steamStats.findLeaderboard(name);
        }
    }

    public static void didCompleteCallback(boolean success) {
        isUploadingScore = false;
        if (statsToUpload.size() > 0) {
            StatTuple uploadMe = statsToUpload.remove();
            SteamSaveSync.uploadLeaderboardScore(uploadMe.stat, uploadMe.score);
        }
    }

    public static void uploadLeaderboardHelper() {
        steamStats.uploadLeaderboardScore(lbHandle, SteamUserStats.LeaderboardUploadScoreMethod.KeepBest, lbScore, new int[0]);
    }

    public static void getLeaderboardEntryHelper() {
        if (retrieveGlobal) {
            logger.info("Downloading GLOBAL entries: " + startIndex + " - " + endIndex);
            if (CardCrawlGame.mainMenuScreen.leaderboardsScreen.viewMyScore) {
                steamStats.downloadLeaderboardEntries(lbHandle, SteamUserStats.LeaderboardDataRequest.GlobalAroundUser, -9, 10);
                CardCrawlGame.mainMenuScreen.leaderboardsScreen.viewMyScore = false;
            } else {
                steamStats.downloadLeaderboardEntries(lbHandle, SteamUserStats.LeaderboardDataRequest.Global, startIndex, endIndex);
            }
        } else {
            logger.info("Downloading FRIEND entries: " + startIndex + " - " + endIndex);
            steamStats.downloadLeaderboardEntries(lbHandle, SteamUserStats.LeaderboardDataRequest.Friends, startIndex, endIndex);
        }
    }

    static {
        accountId = -1;
        lbHandle = null;
        task = null;
        retrieveGlobal = true;
        gettingTime = false;
        lbScore = 0;
        startIndex = 0;
        endIndex = 0;
        isUploadingScore = false;
        statsToUpload = new LinkedList<StatTuple>();
    }

    private static class StatTuple {
        String stat;
        int score;

        StatTuple(String statName, int scoreVal) {
            this.stat = statName;
            this.score = scoreVal;
        }
    }

    public static enum LeaderboardTask {
        RETRIEVE,
        UPLOAD;

    }
}

